<?php
require_once "sortArrays.php";
require_once "checkCameraDeny.php";
require_once "getUserById.php";
require_once "../Connections.php";
require_once "channels.php";

function checkSignal($stat, $index)
{
   $index += 1;
   $status = 0;
   foreach ($stat as $camera) {
      if ($camera->id == $index) {
         if ($camera->fps[0] != 0 || $camera->fps[1] != 0) {
            return $status = 1;
         }
      }
   }
   return $status;
}

function getCodec($stat, $index)
{
   $codec = [0, 0];
   $index += 1;
   foreach ($stat as $camera) {
      if ($camera->id == $index) {
         $codec[0] = $camera->codec[0];
         $codec[1] = $camera->codec[1];
      }
   }
   return $codec;
}

function getCamerasNames($getterVideo, $getterCamStatInfo, $getterSecurity)
{
   global $UserId;
   $arr = [];
   $stat = $getterCamStatInfo->CamStatInfo;
   $isExistIpcams = true;
   if (isset($getterVideo->video->ipcams) && $getterVideo->video->ipcams <= $getterVideo->video->inputs) {
      $inputs_count = $getterVideo->video->ipcams;
   } else {
      $inputs_count = $getterVideo->video->inputs;
      $isExistIpcams = false;
   }
   if (isset($getterVideo->video->input)) {
      $arr = $getterVideo->video->input;
   } else {
      if (!$isExistIpcams) {
         return [];
      }
      for ($i = 0; $i < $inputs_count; $i++) {
         $arr[$i] = ["index" => $i, "enabled" => 0];
      }
   }
   $data = "{}";
   $cameras = [];

   $arr = sort_nested_arrays($arr, ["index" => "desc"]);
   $arr = fillEmptyChannels($arr, $inputs_count, $isExistIpcams);

   $arr = array_slice($arr, 0, $inputs_count); //ограничиваем количество камер исходя из значения video->ipcams
   $user = GetUserById($UserId, $getterSecurity);
   $accessChannels = getDenyAccess($user);
   $i = 0;
   foreach ($arr as $obj) {
      if ($accessChannels["read"][$i] == 0) {
         $names = json_decode($data, true);
         $access = [
            "read" => !$accessChannels["read"][$i],
            "write" => !$accessChannels["write"][$i],
            "play" => !$accessChannels["play"][$i],
            "ptz" => !$accessChannels["ptz"][$i],
            "soundRead" => !$accessChannels["soundRead"][$i],
            "soundPlay" => !$accessChannels["soundPlay"][$i],
         ];
         $names["access"] = $access;
         if (isset($arr[$i]->access)) {
            $names["accessLevel"] = cutAccess($arr[$i]->access);
         } else {
            $names["accessLevel"] = ["read" => 1, "write" => 1, "play" => 1, "ptz" => 1];
         }
         foreach ($obj as $k => $v) {
            if ($k == "title1251") {
               $names["name"] = $v;
            }
            if ($k == "index") {
               $names["index"] = $v;
            }
            if ($k == "enabled") {
               $names["enabled"] = $v;
            }
         }
         $names["imagetransformation"] = isset($obj->imagetransformation) ? $obj->imagetransformation : 0;
         $names["gpio"] = isset($obj->gpio) ? $obj->gpio : "";
         if (isset($obj->cammodel)) {
            $names["cammodel"] = $obj->cammodel;
         }
         $names["signal"] = checkSignal($stat, $names["index"]);
         $names["codec"] = getCodec($stat, $names["index"]);
         $names["stream2"] = isset($obj->url2);
         $names["ip"] = isset($obj->ip) ? $obj->ip : "";
         $names["port_rtsp"] = isset($obj->port) ? intval($obj->port) : "";
         array_push($cameras, $names);
      }

      $i++;
   }

   $cameras = sort_nested_arrays($cameras, ["index" => "desc"]);

   return $cameras;
}
